$.ssquid = {};

STAT_LEFT=["System","SvScan","SqScan","LDAP","Categorization Engine","Application Signatures","Content Signatures","Reporting Database"];
STAT_RIGHT=["Accounted Information","Network","Requests","Cache","Elevated Privacy","DLP","Image Analyzer","ClamAV","ICAP"]; 
STAT_MIDDLE=["DNSBL"];
STAT_MIDDLE_L=["Website Categories","Mimes","Users","Hosts","IP Addresses"];
STAT_MIDDLE_R=["Cookies Blocked","Cookies Allowed","Connection Failures","DNS Failures","Authentication Failures"];

$.ssquid.params = {
//	url : "http://safesquid.cfg",
	url : "",
	root_tag : "section",
	section : {
		parent_tag : "parentgroup",
		logo_tag : "logo",
		display_name_tag : "comment",
		neg : "neg",
		type_tag : "type",
		desc_tag : "desc",
		enabled_tag : "enabled",
		wizard_tag : "wizard",
		rwd_flag_tag : "flags", //read,write,display
		render_option : "render",
		global_defn : "global",
		subsecton_defn : "subsection",
		template_defn : "template",
		select_defn : "select",
		conf_string_list : "lists",
		rule_value : "value",
		search_options : "FIELD_COMMENT_NAMES",
		function_name : "function"
	},
	content:{
		del : "Please confirm to delete entry"
	},
	report : {
		line : "1000",
		hour_diff : "3600",
		result : "xml",
		div_id : {
			users : "_user",
			user_group : "_usergroup",
			ip : "_ipaddress",
			website : "_website",
			sub_domain : "_subdomain",
			profiles : "_profiles",
			application : "_application",
			categories : "_category",
			upload_content : "_uploadcontent",
			download_content : "_downloadcontent",
			time_profile : "_timeprofile",
			blocked_website : "_blockedwebsite",
			security_breaches : "_securitybreaches",
			connection_failed : "_connectionfailed",
			dns_failed : "_dnsfailed",
			bypass_website : "_bypass"
		},
		heading : {
			size_distribution : "Range",
			users : "Users",
			user_group : "User groups",
			ip : "IP Address",
			website : "Website",
			sub_domain : "Domain",
			profiles : "Profile",
			application : "Application Signature",
			categories : "Categories",
			upload_content : "Upload Content",
			download_content : "Download Content",
			time_profile : "Time Profile",
			blocked_website : "Blocked Website",
			security_breaches : "Security Breaches",
			connection_failed : "Connection Failures",
			dns_failed : "DNS Failures",
			bypass_website : "Bypassed Websites"
		},
		query_builder : {
			select : {
				users : "select users_master.A as A0, requests as A1 ,bandwidth as A2 from ( SELECT L as USER, count(L) as requests ,sum(G) as bandwidth from",				 
				user_group : "select user_groups_master.A as A0, Requests as A1, BW as A2 from (select user_groups.A as user_groups,count(user_groups.A) as Requests,sum(size) as BW  from",
				ip : "select ip_address_master.A as A0, requests as A1,bandwidth as A2 from ( SELECT K as IP, count(K) as requests ,sum(G) as bandwidth from",
				website : "select hosts_master.A as A0, requests as A1,bandwidth  as A2 from ( SELECT X as website, count(X) as requests ,sum(G) as bandwidth from",
				sub_domain : "select hosts_master.A as A0, requests as A1,bandwidth  as A2 from ( SELECT Y as Domain, count(Y) as requests ,sum(G) as bandwidth from",
				profiles : "select profiles_master.A as A0, requests as A1, bandwidth  as A2 from  ( select profiles.A as profiles,count(profiles.A) as requests,sum(size) as bandwidth  from",
				application : "select app_sig_master.A as A0,requests as A1,bandwidth as A2 from ( select app_sig.A as app_sig,count(app_sig.A) as requests,sum(size) as bandwidth  from",
				categories : "select categories_master.A as A0,requests as A1,bandwidth as A2 from ( select categories.A as categories,count(categories.A) as requests,sum(size) as bandwidth  from",
				upload_content : "select uc_types_master.A as A0, requests as A1, bandwidth  as A2 from ( select uc_types.A as uc_types,count(uc_types.A) as requests,sum(size) as bandwidth  from ",
				download_content : "select dc_types_master.A as A0, requests as A1, bandwidth  as A2 from  ( select dc_types.A as download_content,count(dc_types.A) as requests,sum(size) as bandwidth  from  ",
				time_profile : "select time_profiles_master.A as A0, requests as A1, bandwidth  as A2 from  ( select time_profiles.A as time_profiles,count(time_profiles.A) as requests,sum(size) as bandwidth  from ",
				blocked_website : "select hosts_master.A as A0, requests as A1,bandwidth  as A2 from ( SELECT X as website, count(X) as requests ,sum(G) as bandwidth from ",
				security_breaches : "select filter_name_master.A as A0, requests as A1,bandwidth  as A2 from ( SELECT R as security_breach, count(R) as requests ,sum(G) as bandwidth from ",
				connection_failed : "select hosts_master.A as A0, requests as A1 ,bandwidth  as A2 from ( SELECT X as website, count(X) as requests ,sum(G) as bandwidth from ",
				dns_failed : "select hosts_master.A as A0, requests as A1 ,bandwidth  as A2 from ( SELECT X as website, count(X) as requests ,sum(G) as bandwidth from ",
				bypass_website : "select hosts_master.A as A0, requests as A1,bandwidth  as A2 from ( SELECT Y as website, count(Y) as requests ,sum(G) as bandwidth from "
			},
			source : {
				users : "(SELECT main.A as id,L,G,X,R,F,AA,K,U,Z,Y from main",				
				user_group : "((select * from(SELECT A as id,L,G as size,X,R,F,AA,K,U,Z,Y from main ",
				ip : "( SELECT main.A as id,L,G,X,R,F,AA,K,U,Z,Y from main ",
				website : "(  SELECT main.A as id,L,G,X,R,F,AA,K,U,Z,Y from main ",
				sub_domain : "(  SELECT main.A as id,L,G,X,R,F,AA,K,U,Z,Y from main ",
				profiles : "((select * from( SELECT main.A as id,L,G as size,X,R,F,AA,K,U,Z,Y  from main  ",
				application : "((select * from( SELECT main.A as id,L,G as size,X,R,F,AA,K,U,Z,Y  from main  ",
				categories : "((select * from( SELECT main.A as id,L,G as size,X,R,F,AA,K,U,Z,Y from main",
				upload_content : "((select * from( SELECT main.A as id,L,G as size,X,R,F,AA,K,U,Z,Y  from main  ",
				download_content : "((select * from( SELECT main.A as id,L,G as size,X,R,F,AA,K,U,Z,Y  from main",
				time_profile : "((select * from( SELECT main.A as id,L,G as size,X,R,F,AA,K,U,Z,Y  from main",
				blocked_website : "( SELECT id,X,G from (SELECT main.A as id,L,G,X,R,F,AA,K,U,Z,Y from main",
				security_breaches : "( SELECT id ,R,G from (SELECT  main.A as  id,L,G,X,R,F,AA,K,U,Z,Y from main  ",
				connection_failed : "( SELECT id ,X,G from (SELECT  main.A as  id,L,G,X,R,F,AA,K,U,Z,Y from main ",
				dns_failed : "( SELECT id ,X,G from (SELECT  main.A as  id,L,G,X,R,F,AA,K,U,Z,Y from main",
				bypass_website : "( SELECT id,Y,G from (SELECT  main.A as  id,L,G,X,R,F,AA,K,U,Z,Y from main  "
			},
			data_base : {
				order : "ORDER BY D DESC limit",
				date_range : "where D between",
				end_syn : ")"
			},
			join_clause : {
				users : "",
				user_group : "",
				ip : "",
				website : "",
				sub_domain : "",
				profiles : "",
				application : "",
				categories : "",
				upload_content : "",
				download_content : "",
				time_profile : "",
				blocked_website : "",
				security_breaches : "",
				connection_failed : "",
				dns_failed : "",
				bypass_website : ""
			},
			where_clause : {
				users : "",
				user_group : "",
				ip : "",
				website : "",
				sub_domain : "",
				profiles : "",
				application : "",
				categories : "",
				upload_content : "",
				download_content : "",
				time_profile : "",
				blocked_website : "F=403",
				security_breaches : "F=403",
				connection_failed : "U=(select B from cachecode_master WHERE A='TCP_CONNECTION_FAILED')",
				dns_failed : "U=(select B from cachecode_master WHERE A='TCP_DNS_FAILED')",
				bypass_website : "R=(select B from filter_name_master WHERE A='bypass')"
			},
			group_clause : {
				users : "GROUP BY L  ORDER BY bandwidth DESC ),users_master where USER=users_master.B;",
				user_group : ")JOIN user_groups ON id=user_groups.B)GROUP BY user_groups.A)JOIN user_groups_master ON user_groups=user_groups_master.B;",
				ip : "GROUP BY K  ORDER BY bandwidth DESC ),ip_address_master where IP=ip_address_master.B;",
				website : "GROUP BY X  ORDER BY bandwidth DESC ),hosts_master where website=hosts_master.B;",
				sub_domain : "GROUP BY Y  ORDER BY bandwidth DESC ),hosts_master where Domain=hosts_master.B;",
				profiles : ")JOIN profiles ON id=profiles.B) GROUP BY profiles.A) JOIN profiles_master ON profiles=profiles_master.B;",
				application : ")JOIN app_sig ON id=app_sig.B) GROUP BY app_sig.A) JOIN app_sig_master ON app_sig=app_sig_master.B;",
				categories : ")JOIN categories ON id=categories.B) GROUP BY categories.A) JOIN categories_master ON categories=categories_master.B;",
				upload_content : ")JOIN uc_types ON id=uc_types.B) GROUP BY uc_types.A) JOIN uc_types_master ON uc_types=uc_types_master.B;",
				download_content : ")JOIN dc_types ON id=dc_types.B) GROUP BY dc_types.A) JOIN dc_types_master ON download_content=dc_types_master.B;",
				time_profile : ")JOIN time_profiles ON id=time_profiles.B) GROUP BY time_profiles.A) JOIN time_profiles_master ON time_profiles=time_profiles_master.B;",
				blocked_website : " ) GROUP BY X  ORDER BY bandwidth DESC ),hosts_master where website=hosts_master.B;",
				security_breaches : " ) GROUP BY R  ORDER BY bandwidth DESC ),filter_name_master where security_breach=filter_name_master.B;",
				connection_failed : " ) GROUP BY X  ORDER BY bandwidth DESC ),hosts_master where website=hosts_master.B;",
				dns_failed : " ) GROUP BY X  ORDER BY bandwidth DESC ),hosts_master where website=hosts_master.B;",
				bypass_website : " ) GROUP BY Y  ORDER BY bandwidth DESC ),hosts_master where website=hosts_master.B;"
			}
		}
	},
	handler : {
		section_xml : "handler=structured_xml",
		config_xml : "handler=conf_xml",
		subscription : "handler=subscription&refresh=",
		save : "handler=save&filename=config.xml",
		authentication : "handler=login_interface",
		performance : "handler=generic_script_handler&script_to_execute=modify_plot.sh",
		config_log : "handler=config_log",
		view_log : "handler=log",
		svscan_status : "handler=virus_information",
		support_list : "handler=support_tarball&list=true",
		config_list : "handler=config_xml&list=true",
		category_manager : "handler=category_manager",
		list_handler : "handler=get_list&",
		ssl_cache : "handler=ssl_cache_manage",
		policy_search : "handler=policy_search",
		search_options : "handler=get_list&list_name=FIELD_COMMENT_NAMES",
		extended_logs : "handler=extended_log",
		password_cache_list : "handler=password_cache&password_cache_list=true",
		password_cache_delete_user : "handler=password_cache&users_list=",
		reporting : "handler=reporting&format=xml",
		show_ldap : "handler=ldap&refresh=true",
		cache : "handler=cache",
		account_info : "handler=users_information",
		sscore : "handler=category_signatures",
		dns_cache : "handler=dnscache&loop=4",
		active_connections : "handler=active_connections&loop=4",
		connection_pool : "handler=connection_pool&loop=4",
		startup : "handler=safesquid_params",
		restart : "handler=safesquid_restart",
		cloud_backup: "handler=cloud_backup",
		kerberos : "handler=generic_script_handler&script_to_execute=kerberos.sh",
		cloud_restore : "handler=cloud_restore",
		stats : "handler=stats&loop=4",
		bypass : "handler=bypass_log"
	},
	js_files : {
		ldap_entries : "show_ldap.js",
		account_info : "account_info.js",
		logs : "view_log.js",
		active_connections : "active_connections.js",
		password_cache : "password_cache.js",
		modules_status : "module_status.js",
		ssl_cache : "ssl_cache.js",
		reports : "reports.js",
		support : "performance.js,support_tar.js,startup.js",
		encrypt_password : "encrypt_password.js",
		cache : "cache.js",
		prefetch : "prefetch.js",
		connection_pool : "connection_pool.js",
		header_filter : "header_filter.js",
		stats_data: "stats_data.js"
	}
};
