$(document).ready(function () {
	$("#subscription").load(LOAD_XML("subscription", "subscription_details"), function () {
		console.log("subscription loaded");
	});
});

function LOAD_XML(query_site, divID) {
	var datafetch = new XMLHttpRequest();
	var MAKE_URL = "handler=" + query_site;
	datafetch.open("POST", MAKE_URL, true);
	datafetch.onreadystatechange = function () {
	  
		if (datafetch.readyState == 4 && datafetch.status == 200) {
			LOAD_DATA_TO_WEBPAGE(datafetch, divID);
             
		}
        else{
           
          
        }
	}

	datafetch.setRequestHeader('Access-Control-Allow-Headers', '*');
	datafetch.setRequestHeader('Access-Control-Allow-Methods', 'GET');
	datafetch.send();

}

function LOAD_DATA_TO_WEBPAGE(xmlresponse, divID) {
	var responsexmlDoc = xmlresponse.responseXML;
	var $xmlresponse = $(responsexmlDoc);

	
	switch (divID) {
	case "subscription_details":
		$xml_subsrciption = $xmlresponse.find('subscription_details').find('information');
		NOTIFICATION = GET_ATTR($xml_subsrciption, 'remarks');

        
		 if(NOTIFICATION == "Failed to set Subscription details"){
           $('#upload_activation_key').css('display','block');
			alert(NOTIFICATION);
			}
            else if(NOTIFICATION == ""){
              $('#upload_activation_key').css('display','block');  
            }
			else{
			 $('#upload_activation_key').css('display','none');	
			}
		
		 $('#subscription_notification').append('<font">'+NOTIFICATION+'</font>');
		 $('#version').append($xml_subsrciption.attr('version'));
        //
		DATA_ENTRY = "";
		DATA_ENTRY += '<button type="button" style="float:right" class="btn btn-xs" onclick="get_subscription_details()">Refresh details</button><br />';        
		DATA_ENTRY += '<strong>Service ID</strong><p class="text-muted">' + GET_ATTR($xml_subsrciption, 'service_id') + '</p><hr>';
		DATA_ENTRY += '<strong>Activation Key</strong><p class="text-muted">' + GET_ATTR($xml_subsrciption, 'activation_key_name') + '</p><hr>';
		DATA_ENTRY += '<strong>Generated By</strong><p class="text-muted">' + GET_ATTR($xml_subsrciption, 'creater_details') + '</p><hr>';
		DATA_ENTRY += '<strong>Subscription Type</strong><p class="text-muted">' + GET_ATTR($xml_subsrciption, 'service_subscription_type') + '</p><hr>';
		DATA_ENTRY += '<strong>Subscription Expiry</strong><p class="text-muted">' + GET_ATTR($xml_subsrciption, 'service_remaining_quantity') + '</p><hr>';
		DATA_ENTRY += '<strong>Service Name</strong><p class="text-muted">' + GET_ATTR($xml_subsrciption, 'service_name') + '</p><hr>';
		DATA_ENTRY += '<strong>Service Deployed</strong><p class="text-muted">' + GET_ATTR($xml_subsrciption, 'service_location') + '</p><hr>';
		DATA_ENTRY += '<strong>Incharge detail</strong><p class="text-muted">' + GET_ATTR($xml_subsrciption, 'contact_person_details') + '</p><hr>';
		DATA_ENTRY += '<strong>Notification</strong><p class="text-muted">' + NOTIFICATION + '</p><hr>';
		DATA_ENTRY += '<strong>Version</strong><p class="text-muted">' + $xml_subsrciption.attr('version') + '</p><hr>';
			
		break;
	default:
		console.log("invalid query");
		break;
	}
    
	$('#' + divID).html(DATA_ENTRY);

}

function GET_ATTR($xml_subsrciption, attr_name) {
	$value = $xml_subsrciption.attr(attr_name);

	if ($value == undefined)
		return "";
	else
		return $value
}

//cookie functions

function Set_Cookie(name, value, expires, path, domain) {
	var today = new Date();
	today.setTime(today.getTime());

	if (expires) {
		expires = expires * 1000 * 60 * 60;
	}
	var expires_date = new Date(today.getTime() + (expires));

	document.cookie = name + "=" + escape(value) +
		((expires) ? ";expires=" + expires_date.toGMTString() : "") +
		((path) ? ";path=" + path : "") +
		((domain) ? ";domain=" + domain : "")
}
//Get cookie function
function Get_Cookie(check_name) {
	// first we'll split this cookie up into name/value pairs
	// note: document.cookie only returns name=value, not the other components
	var a_all_cookies = document.cookie.split(';');
	var a_temp_cookie = '';
	var cookie_name = '';
	var cookie_value = '';
	var b_cookie_found = false; // set boolean t/f default f

	for (i = 0; i < a_all_cookies.length; i++) {
		// now we'll split apart each name=value pair
		a_temp_cookie = a_all_cookies[i].split('=');

		// and trim left/right whitespace while we're at it
		cookie_name = a_temp_cookie[0].replace(/^\s+|\s+$/g, '');

		// if the extracted name matches passed check_name
		if (cookie_name == check_name) {
			b_cookie_found = true;
			// we need to handle case where cookie has no value but exists (no = sign, that is):
			if (a_temp_cookie.length > 1) {
				cookie_value = unescape(a_temp_cookie[1].replace(/^\s+|\s+$/g, ''));
			}
			// note that in cases where cookie is initialized but no value, null is returned
			return cookie_value;
			break;
		}
		a_temp_cookie = null;
		cookie_name = '';
	}
	if (!b_cookie_found) {
		return null;
	}
}

// this deletes the cookie when called
function Delete_Cookie(name, path, domain) {
	if (Get_Cookie(name))
		document.cookie = name + "=" +
			((path) ? ";path=" + path : "") +
			((domain) ? ";domain=" + domain : "") +
			";expires=Thu, 01-Jan-1970 00:00:01 GMT";
}


function get_subscription_details (){
    $("#subscription").load(LOAD_XML("subscription", "subscription_details"), function () {
		console.log("subscription loaded");
	});
}